#include "Timer.h"
#include <wx/utils.h>
#include <wx/timer.h>

Timer::Timer(void)
{
	start();
}

Timer::~Timer(void)
{
}

unsigned long Timer::start()
{
	_lastMark = _startTime = 0;
	::wxStartTimer();
	return _startTime;
}

void Timer::wait(unsigned long sometime)
{
	::wxMilliSleep(sometime);
}

unsigned long Timer::getElapsedTime(bool mark)
{
	unsigned long now = ::wxGetElapsedTime(false);
	unsigned long retVal = now - _lastMark;
	if(mark)
	{
		_lastMark = now;
	}
	return retVal;
}

unsigned long Timer::getTotalElapsedTime(bool mark)
{
	unsigned long now = ::wxGetElapsedTime(false);
	if(mark)
	{
		_lastMark = now;
	}

	return now - _startTime;
}
